//Scheduler event handler add-on public API header file
#pragma once


//******************************************************************************************************
//**** PROJECT HEADER FILES AND CLASS NAME DECLARATIONS
//******************************************************************************************************
#include "BufferedFile.h"	//Santa's gift bag
#include "SchedulerBuild.h"
#include "Event.h"


//******************************************************************************************************
//**** EventAddOnData CLASS DECLARATION
//******************************************************************************************************
class _SCHIMPEXP EventAddOnData
{
	public:
		EventAddOnData(Event* AttachTo);

		//Functions which must be implemented by derived classes
		virtual ~EventAddOnData();
			//Virtual destructor used to call derived classes' destructors.
		virtual BView* CreateEditView(BRect frame) = 0;
			//Create the view that is used to edit the event data.
			//If the user makes any changes, you should call GetAttachedTo()->SetModified();  Note that
			//when you do this, you need to wrap it in ReadWriteLock() and ReadWriteUnlock() calls to
			//the AssertableRWSemaphore returned by GetAttachedTo()->GetProtectionSemaphore();
		virtual bool SaveData(BufferedFile* File) = 0;
			//Allows the add-on to store its data into the Event set file.  In case the add-on is
			//unavailable, the first thing that should be written is a 32-bit integer indicating the
			//length of the rest of the data in bytes (not including the 4 bytes for the size).  The
			//file will already contain data for other events, etc.  Should return true if everything
			//was OK, false if a file error occurred.
		virtual void DealWithEvent(bool IsEventLate) = 0;
			//   There are four types of event handlers:
			//
			//1. Those that do something immediately without user interaction
			//2. Those that inform the user of the event and require that interaction to be completed
			//before the next event can be delivered (next of all events, not necessarily next incarnation
			//of this event)
			//3. Those that start a time-consuming process and have a user interface to indicate status
			//4. Those that start a time-consuming process and have no user interface (discouraged)
			//
			//Each type is handled in a different way:
			//1. In DealWithEvent:
			//		Just perform the action
			//2. In DealWithEvent:
			//		The user interaction must use a modal dialog (usually BAlert) and DealWithEvent may not
			//		return until the user interaction is completed.  Make sure you don't hold the event
			//      protection semaphore while you're in the modal dialog.  If the action delivers some
			//		sort of message, you should check GetAttachedTo()->GetApplyNag().  If it is true, then
			//		you should give the user a "Don't nag" option, and if the user selects not to nag,
			//		call GetAttachedTo()->SetSkipNag().
			//3 or 4. In DealWithEvent:
			//		Start the time-consuming action.  After DealWithEvent returns, the event will be
			//			updated and possibly deleted, so the time-consuming process should already have all
			//			the information that it needs internally so that it is not dependent on the Event,
			//			the EventAddOnData, or your class derived from EventAddOnData.
			//		Before spawning the thread:
			//			EventAddOnData::ProcessHold() must be called.  This keeps the app from quitting.
			//		When the thread is done:
			//			EventAddOnData::ProcessDone() must be called.
			//
			//The event should be delivered in such a manner as to indicate that it is late if IsEventLate
			//is true.
			//
			//After DealWithEvent returns, the event will be incremented to the next instance, its state will
			//be altered to nag or prewarning for the next event, or the event will be deleted, depending on
			//what the user wants.
			//
			//When DealWithEvent enters, the semaphore to protect the event and set from modification is
			//NOT held.  You do not need to lock the semaphore to protect your own data as nobody else knows
			//about it, however, if you want to get information about the parent event (passed to the
			//EventAddOnData constructor as AttachTo), you do need to read lock the semaphore.  The semaphore
			//can be obtained by calling AttachTo->GetProtectionSemaphore().  Make sure to unlock the
			//semaphore before displaying any application modal windows (putting up a BAlert, for example).

		//Functions with fixed implementations
		virtual void DestroyEditView();			//Removes the edit view and its contents
		BView* GetEditView();						//Returns the edit view
		void RecordEditView(BView* TheEditView);	//Records the edit view
		Event* GetParentEvent();					//Returns the Event this is attached to
		static void ProcessHold();					//Tell the application that a time-consuming process is in progress
		static void ProcessDone();					//Tell the application that the time-consuming process is done
		Event* GetAttachedTo();

	private:
		//FBC protection
		virtual void EAODReserved1();
		virtual void EAODReserved2();
		virtual void EAODReserved3();
		virtual void EAODReserved4();
		virtual void EAODReserved5();
		virtual void EAODReserved6();
		int32 EAODReserved7;
		int32 EAODReserved8;
		int32 EAODReserved9;
		int32 EAODReserved10;
		int32 EAODReserved11;
		int32 EAODReserved12;

		BView* EditView;			//Edit view created by the add-on in the Event window (NOT the
									//event delivery window from DealWithEvent())
		Event* AttachedTo;
};


//******************************************************************************************************
//**** FUNCTION DECLARATIONS
//******************************************************************************************************
_SCHIMPEXP int32 DeliverEventMessage(Event* AttachedTo,bool IsEventLate,const char* Message1,const char* Message2,
	const char* Message3,const char* Message4,const char* Message5,const char* Button0,const char* Button1);
	//This is a function that is quite useful.  It displays a dialog containing information about the event,
	//including time, if it was missed, etc. etc., nicely phrased, then displays the concatenated message
	//given in the three message strings (which may be NULL too), along with one or two buttons (if one button)
	//then set the second button label pointer to NULL.

_SCHIMPEXP status_t WriteAddOnSetting(const char* SettingName,const void* data,size_t size,
	uint32 type = B_RAW_TYPE);
_SCHIMPEXP status_t ReadAddOnSetting(const char* SettingName,const void*& out_data,ssize_t& out_size,
	uint32& out_type);
	//These functions let you store settings along with Scheduler's settings.  The calling conventions match
	//those of Jon Watte's libprefs, which Scheduler actually uses.  To prevent naming conflicts, you should
	//prepend your SettingName with the name of your add-on, for example "MyAddOnName_SomeSettingName".


//******************************************************************************************************
//**** FUNCTIONS WHICH MUST BE EXPORTED BY ADD-ONS
//******************************************************************************************************

/* These functions need to be exported by your add-on:
__declspec(dllexport) extern "C" char* InitializeAddOn();
__declspec(dllexport) extern "C" EventAddOnData* NewAddOnData(Event* AttachTo,BufferedFile* LoadFile,bool* FileOK);
__declspec(dllexport) extern "C" void CleanUpAddOn();

char* InitializeAddOn()
	Called as soon as each add-on image is loaded.  Doesn't necessarily have to do anything except return
	the name of the add-on.  Returning NULL indicates that an error occurred and the add-on should be
	unloaded immediately.  The following names are taken by the default event handlers: "Unknown",
	"Do nothing","Message","Command","Shell script","Act on file".  Please check with me (btietz@ucsd.edu)
	before choosing a name so I can make sure that no two third-party add-ons are given the same name.
	If your initialization fails, return NULL and your add-on will be ignored by Scheduler.

EventAddOnData* NewAddOnData(Event* AttachTo,BufferedFile* LoadFile,bool* FileOK)
	Called to create a new instance of add-on data.  If file is NULL, the event should be created as
	untitled with default values.  Otherwise, File will currently be at the 32-bit size value that the
	add-on previously wrote in EventAddOnData::SaveData().  FileOK is used to return to the caller
	whether everything went file with the file.  true indicates everything was fine, false indicates
	that a file error occurred.

void CleanUpAddOn()
	Called just before each add-on image is unloaded.


*/
